#!/bin/bash

set -eo pipefail

. ./VERSION

if [ -z "$PROJECT_VERSION" ]; then
    echo "PROJECT_VERSION not set; required."
    exit 1
fi

if [ -z "$PROJECT_RELEASE" ]; then
    echo "PROJECT_RELEASE not set; required."
    exit 1
fi

TAG="v${PROJECT_VERSION}-${PROJECT_RELEASE}"
DESC="Development release ${TAG}"

if [ -n "$NETIFY_PLM_MINVER" -a "${NETIFY_PLM_MINVER_RELEASE}" ]; then
    DESC="${DESC} (PLM v${NETIFY_PLM_MINVER}-${NETIFY_PLM_MINVER_RELEASE})"
fi

if [ -n "$NETIFY_MINVER" -a "${NETIFY_MINVER_RELEASE}" ]; then
    DESC="${DESC} for Agent v${NETIFY_MINVER}-${NETIFY_MINVER_RELEASE}"
fi

echo "Tag: ${TAG}"

if git tag -l 'v[0-9]*' | grep -q ${TAG}; then
    while true; do
        read -r -N 1 -p "Tag exists, delete it? " answer
        case $answer in
            [Yy]*)
                echo
                git tag -d ${TAG}
                break
            ;;
            [Nn]* )
                echo
                exit 0
            ;;
            *)
                echo -e "\nPlease answer ${BOLD}Y${NORMAL} or ${BOLD}N${NORMAL}."
            ;;
        esac
    done
fi

read -e -i "${DESC}." -p "Description: " DESC

git tag -a ${TAG} -m "${DESC}"

while true; do
    read -r -N 1 -p "Push tag now? " answer
    case $answer in
        [Yy]*)
            echo
            git push --tags
            break
        ;;
        [Nn]* )
            echo
            exit 0
        ;;
        *)
            echo -e "\nPlease answer ${BOLD}Y${NORMAL} or ${BOLD}N${NORMAL}."
        ;;
    esac
done

exit 0
