#!/usr/bin/bash

src_dir=/home/dsokoloski/netify-daemon

generate_response_code()
{
    i=1

    if [ "$1" == "php" ]; then
        echo -e "<?php\n"
    fi

    cat << EOF
// Auto-generated JSON response codes 
// WARNING: All modifications will be LOST!

EOF

    if [ "$1" == "c" ]; then
        cat << EOF
#ifndef _ND_JSON_RESPONSE_CODE_H
#define _ND_JSON_RESPONSE_CODE_H

enum ndJsonResponseCode
{
    ndJSON_RESP_NULL = 0,
EOF
    fi

    while read token; do
        t=$(echo $token | tr '[:lower:]' '[:upper:]')
        if [ "$1" == "c" ]; then
            printf "    ndJSON_RESP_%s = %d,\n" $t $i
        elif [ "$1" == "php" ]; then
            printf "define('NS_JSON_RESP_%s', %d);\n" $t $i
        fi
        i=$[ $i + 1 ]
    done < $src_dir/include/nd-json-response-code.txt.in

    if [ "$1" == "c" ]; then
        cat << EOF
    ndJSON_RESP_MAX = $i
};

#endif // _ND_JSON_RESPONSE_CODE_H
EOF
    fi
}

case "$1" in
c-response-code)
    generate_response_code c
    ;;
php-response-code)
    generate_response_code php
    ;;
*)
    exit 1
esac

exit 0

# vi: expandtab shiftwidth=4 softtabstop=4 tabstop=4
