/*
 * ndpi_content_match.c.inc
 *
 * Copyright (C) 2011-22 - ntop.org
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* ****************************************************** */

static ndpi_network host_protocol_list[] = {
  /*
    SoundCloud
    TODO: are we able to autogenerate this list?
  */
  { 0x22FB2FEE /* 34.251.47.238 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x23A06456 /* 35.160.100.86 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x36C0CA58 /* 54.192.202.88 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },

  /*
    Instagram, Inc.
    (instagram-*.fbcdn.net, fna-instagram-*.fbcdn.net)
    TODO: are we able to autogenerate this list (like the other FB IPs)?
  */
  { 0x9DF00225 /* 157.240.2.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00234 /* 157.240.2.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF002AC /* 157.240.2.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF002AE /* 157.240.2.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00326 /* 157.240.3.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0033F /* 157.240.3.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF003AC /* 157.240.3.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF003AE /* 157.240.3.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00625 /* 157.240.6.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00634 /* 157.240.6.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF006AC /* 157.240.6.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF006AE /* 157.240.6.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00725 /* 157.240.7.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00734 /* 157.240.7.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF007AC /* 157.240.7.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF007AE /* 157.240.7.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00825 /* 157.240.8.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00834 /* 157.240.8.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF008AC /* 157.240.8.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF008AE /* 157.240.8.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00925 /* 157.240.9.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00934 /* 157.240.9.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF009AC /* 157.240.9.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF009AE /* 157.240.9.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00A25 /* 157.240.10.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00A34 /* 157.240.10.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00AAC /* 157.240.10.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00AAE /* 157.240.10.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00B25 /* 157.240.11.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00B34 /* 157.240.11.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00BAC /* 157.240.11.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00BAE /* 157.240.11.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00C25 /* 157.240.12.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00C34 /* 157.240.12.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00CAC /* 157.240.12.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00CAE /* 157.240.12.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00D25 /* 157.240.13.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00D34 /* 157.240.13.52/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00DAC /* 157.240.13.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00DAE /* 157.240.13.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00E25 /* 157.240.14.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00E3F /* 157.240.14.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00EAC /* 157.240.14.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00EAE /* 157.240.14.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00F20 /* 157.240.15.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00F3F /* 157.240.15.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00FAC /* 157.240.15.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF00FAE /* 157.240.15.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01025 /* 157.240.16.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0103F /* 157.240.16.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF010AC /* 157.240.16.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF010AE /* 157.240.16.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01126 /* 157.240.17.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0113F /* 157.240.17.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF011AC /* 157.240.17.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF011AE /* 157.240.17.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01225 /* 157.240.18.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0123F /* 157.240.18.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF012AC /* 157.240.18.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF012AE /* 157.240.18.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01327 /* 157.240.19.39/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0133F /* 157.240.19.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF013AC /* 157.240.19.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF013AE /* 157.240.19.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01425 /* 157.240.20.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0143F /* 157.240.20.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF014AC /* 157.240.20.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF014AE /* 157.240.20.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01525 /* 157.240.21.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0153F /* 157.240.21.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF015AC /* 157.240.21.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF015AE /* 157.240.21.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01625 /* 157.240.22.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0163F /* 157.240.22.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF016AC /* 157.240.22.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF016AE /* 157.240.22.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01726 /* 157.240.23.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0173F /* 157.240.23.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF017AC /* 157.240.23.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF017AE /* 157.240.23.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01820 /* 157.240.24.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0183F /* 157.240.24.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF018AC /* 157.240.24.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF018AE /* 157.240.24.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01920 /* 157.240.25.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0193F /* 157.240.25.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF019AC /* 157.240.25.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF019AE /* 157.240.25.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01A26 /* 157.240.26.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01A3F /* 157.240.26.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01AAC /* 157.240.26.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01AAE /* 157.240.26.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01B26 /* 157.240.27.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01B3F /* 157.240.27.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01BAC /* 157.240.27.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01BAE /* 157.240.27.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01C25 /* 157.240.28.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01C3F /* 157.240.28.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01CAC /* 157.240.28.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01CAE /* 157.240.28.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01E26 /* 157.240.30.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01E3F /* 157.240.30.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01EAC /* 157.240.30.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF01EAE /* 157.240.30.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0809F /* 157.240.128.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF080A1 /* 157.240.128.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF080B6 /* 157.240.128.182/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0821F /* 157.240.130.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08220 /* 157.240.130.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0822B /* 157.240.130.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0831F /* 157.240.131.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08320 /* 157.240.131.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0832B /* 157.240.131.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0851F /* 157.240.133.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08520 /* 157.240.133.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0852B /* 157.240.133.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0871F /* 157.240.135.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08720 /* 157.240.135.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0872B /* 157.240.135.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0881F /* 157.240.136.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08820 /* 157.240.136.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0882B /* 157.240.136.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08A1F /* 157.240.138.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08A20 /* 157.240.138.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08A2B /* 157.240.138.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08B1F /* 157.240.139.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08B21 /* 157.240.139.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08B2B /* 157.240.139.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08C1F /* 157.240.140.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08C21 /* 157.240.140.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08C2B /* 157.240.140.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08D1F /* 157.240.141.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08D21 /* 157.240.141.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08D2B /* 157.240.141.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08E1F /* 157.240.142.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08E21 /* 157.240.142.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08E2B /* 157.240.142.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08F1F /* 157.240.143.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08F21 /* 157.240.143.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF08F2B /* 157.240.143.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0901F /* 157.240.144.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09021 /* 157.240.144.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0902B /* 157.240.144.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0911F /* 157.240.145.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09121 /* 157.240.145.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0912B /* 157.240.145.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0921F /* 157.240.146.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09221 /* 157.240.146.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0922B /* 157.240.146.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0931F /* 157.240.147.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09321 /* 157.240.147.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0932B /* 157.240.147.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0941F /* 157.240.148.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09421 /* 157.240.148.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0942B /* 157.240.148.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0971F /* 157.240.151.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09721 /* 157.240.151.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0972B /* 157.240.151.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0981F /* 157.240.152.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09821 /* 157.240.152.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0982B /* 157.240.152.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09B9F /* 157.240.155.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09BA1 /* 157.240.155.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09BB7 /* 157.240.155.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09E9F /* 157.240.158.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09EA1 /* 157.240.158.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09EB7 /* 157.240.158.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09F9F /* 157.240.159.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09FA1 /* 157.240.159.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF09FB7 /* 157.240.159.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A21F /* 157.240.162.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A221 /* 157.240.162.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A22B /* 157.240.162.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A25F /* 157.240.162.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A261 /* 157.240.162.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A26B /* 157.240.162.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A29F /* 157.240.162.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A2A1 /* 157.240.162.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A2AB /* 157.240.162.171/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A2DF /* 157.240.162.223/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A2E1 /* 157.240.162.225/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A2EB /* 157.240.162.235/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A41F /* 157.240.164.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A421 /* 157.240.164.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A42B /* 157.240.164.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A45F /* 157.240.164.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A461 /* 157.240.164.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A46B /* 157.240.164.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A51F /* 157.240.165.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A521 /* 157.240.165.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A52B /* 157.240.165.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A55F /* 157.240.165.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A561 /* 157.240.165.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A56B /* 157.240.165.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A61F /* 157.240.166.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A621 /* 157.240.166.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A62B /* 157.240.166.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A65F /* 157.240.166.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A661 /* 157.240.166.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A66B /* 157.240.166.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A71F /* 157.240.167.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A721 /* 157.240.167.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A72B /* 157.240.167.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A75F /* 157.240.167.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A761 /* 157.240.167.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A76B /* 157.240.167.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A81F /* 157.240.168.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A821 /* 157.240.168.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A82B /* 157.240.168.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A85F /* 157.240.168.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A861 /* 157.240.168.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A86B /* 157.240.168.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A99E /* 157.240.169.158/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A9A1 /* 157.240.169.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0A9B7 /* 157.240.169.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AC9F /* 157.240.172.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0ACA2 /* 157.240.172.162/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0ACB7 /* 157.240.172.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AD1F /* 157.240.173.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AD21 /* 157.240.173.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AD2B /* 157.240.173.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AE9F /* 157.240.174.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AEA1 /* 157.240.174.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AEB7 /* 157.240.174.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AF1F /* 157.240.175.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AF21 /* 157.240.175.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0AF2B /* 157.240.175.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B09F /* 157.240.176.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B0A1 /* 157.240.176.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B0B7 /* 157.240.176.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B19F /* 157.240.177.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B1A1 /* 157.240.177.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B1B7 /* 157.240.177.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B29F /* 157.240.178.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B2A1 /* 157.240.178.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B2B7 /* 157.240.178.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B39F /* 157.240.179.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B3A1 /* 157.240.179.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B3B7 /* 157.240.179.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B49F /* 157.240.180.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B4A1 /* 157.240.180.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B4B7 /* 157.240.180.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B59F /* 157.240.181.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B5A1 /* 157.240.181.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0B5B7 /* 157.240.181.183/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BA5F /* 157.240.186.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BA61 /* 157.240.186.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BA6B /* 157.240.186.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BB5F /* 157.240.187.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BB61 /* 157.240.187.97/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BB6B /* 157.240.187.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BC9F /* 157.240.188.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BCA1 /* 157.240.188.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BCAB /* 157.240.188.171/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BCDF /* 157.240.188.223/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BCE1 /* 157.240.188.225/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BCEB /* 157.240.188.235/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD1F /* 157.240.189.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD20 /* 157.240.189.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD2B /* 157.240.189.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD5F /* 157.240.189.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD60 /* 157.240.189.96/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BD6B /* 157.240.189.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE1F /* 157.240.190.31/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE20 /* 157.240.190.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE2B /* 157.240.190.43/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE5F /* 157.240.190.95/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE60 /* 157.240.190.96/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE6B /* 157.240.190.107/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BE9F /* 157.240.190.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BEA1 /* 157.240.190.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BEAB /* 157.240.190.171/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BEDF /* 157.240.190.223/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BEE1 /* 157.240.190.225/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BEEB /* 157.240.190.235/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BF1E /* 157.240.191.30/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BF20 /* 157.240.191.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BF2A /* 157.240.191.42/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BF9F /* 157.240.191.159/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BFA1 /* 157.240.191.161/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BFAB /* 157.240.191.171/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BFDF /* 157.240.191.223/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BFE1 /* 157.240.191.225/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0BFEB /* 157.240.191.235/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C025 /* 157.240.192.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C03F /* 157.240.192.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C0AC /* 157.240.192.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C0AE /* 157.240.192.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C226 /* 157.240.194.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C23F /* 157.240.194.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C2AC /* 157.240.194.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C2AE /* 157.240.194.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C325 /* 157.240.195.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C33F /* 157.240.195.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C3AC /* 157.240.195.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C3AE /* 157.240.195.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C425 /* 157.240.196.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C43F /* 157.240.196.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C4AC /* 157.240.196.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C4AE /* 157.240.196.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C525 /* 157.240.197.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C53F /* 157.240.197.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C5AC /* 157.240.197.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C5AE /* 157.240.197.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C625 /* 157.240.198.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C63F /* 157.240.198.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C6AC /* 157.240.198.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C6AE /* 157.240.198.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C726 /* 157.240.199.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C73F /* 157.240.199.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C7AC /* 157.240.199.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C7AE /* 157.240.199.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C825 /* 157.240.200.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C83F /* 157.240.200.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C8AC /* 157.240.200.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C8AE /* 157.240.200.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C925 /* 157.240.201.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C93F /* 157.240.201.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C9AC /* 157.240.201.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0C9AE /* 157.240.201.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CC25 /* 157.240.204.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CC3F /* 157.240.204.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CCAC /* 157.240.204.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CCAE /* 157.240.204.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CD20 /* 157.240.205.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CD3F /* 157.240.205.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CDAC /* 157.240.205.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CDAE /* 157.240.205.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CE25 /* 157.240.206.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CE3F /* 157.240.206.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CEAC /* 157.240.206.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CEAE /* 157.240.206.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CF25 /* 157.240.207.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CF3F /* 157.240.207.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CFAC /* 157.240.207.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0CFAE /* 157.240.207.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D025 /* 157.240.208.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D03F /* 157.240.208.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D0AC /* 157.240.208.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D0AE /* 157.240.208.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D125 /* 157.240.209.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D13F /* 157.240.209.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D1AC /* 157.240.209.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D1AE /* 157.240.209.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D225 /* 157.240.210.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D23F /* 157.240.210.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D2AC /* 157.240.210.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D2AE /* 157.240.210.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D321 /* 157.240.211.33/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D33F /* 157.240.211.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D3AC /* 157.240.211.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D3AE /* 157.240.211.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D425 /* 157.240.212.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D43F /* 157.240.212.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D4AC /* 157.240.212.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D4AE /* 157.240.212.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D525 /* 157.240.213.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D53F /* 157.240.213.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D5AC /* 157.240.213.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D5AE /* 157.240.213.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D620 /* 157.240.214.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D63F /* 157.240.214.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D6AC /* 157.240.214.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D6AE /* 157.240.214.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D725 /* 157.240.215.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D73F /* 157.240.215.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D7AC /* 157.240.215.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D7AE /* 157.240.215.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D825 /* 157.240.216.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D83F /* 157.240.216.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D8AC /* 157.240.216.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D8AE /* 157.240.216.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D926 /* 157.240.217.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D93F /* 157.240.217.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D9AC /* 157.240.217.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0D9AE /* 157.240.217.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DA26 /* 157.240.218.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DA3F /* 157.240.218.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DAAC /* 157.240.218.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DAAE /* 157.240.218.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DC25 /* 157.240.220.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DC3F /* 157.240.220.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DCAC /* 157.240.220.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DCAE /* 157.240.220.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DD26 /* 157.240.221.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DD3F /* 157.240.221.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DDAC /* 157.240.221.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DDAE /* 157.240.221.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DE25 /* 157.240.222.37/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DE3F /* 157.240.222.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DEAC /* 157.240.222.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DEAE /* 157.240.222.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DF26 /* 157.240.223.38/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DF3F /* 157.240.223.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DFAC /* 157.240.223.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0DFAE /* 157.240.223.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E020 /* 157.240.224.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E03F /* 157.240.224.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E0AC /* 157.240.224.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E0AE /* 157.240.224.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E120 /* 157.240.225.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E13F /* 157.240.225.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E1AC /* 157.240.225.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E1AE /* 157.240.225.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E220 /* 157.240.226.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E23F /* 157.240.226.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E2AC /* 157.240.226.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E2AE /* 157.240.226.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E320 /* 157.240.227.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E33F /* 157.240.227.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E3AC /* 157.240.227.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E3AE /* 157.240.227.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E420 /* 157.240.228.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E43F /* 157.240.228.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E4AC /* 157.240.228.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E4AE /* 157.240.228.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E520 /* 157.240.229.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E53F /* 157.240.229.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E5AC /* 157.240.229.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E5AE /* 157.240.229.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E5C6 /* 157.240.229.198/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E720 /* 157.240.231.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E73F /* 157.240.231.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E7AC /* 157.240.231.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E7AE /* 157.240.231.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E820 /* 157.240.232.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E83F /* 157.240.232.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E8AC /* 157.240.232.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E8AE /* 157.240.232.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E920 /* 157.240.233.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E93F /* 157.240.233.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E9AC /* 157.240.233.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0E9AE /* 157.240.233.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EA20 /* 157.240.234.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EA3F /* 157.240.234.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EAAC /* 157.240.234.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EAAE /* 157.240.234.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EB20 /* 157.240.235.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EB3F /* 157.240.235.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EBAC /* 157.240.235.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EBAE /* 157.240.235.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EC20 /* 157.240.236.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EC3F /* 157.240.236.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0ECAC /* 157.240.236.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0ECAE /* 157.240.236.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EF20 /* 157.240.239.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EF3F /* 157.240.239.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EFAC /* 157.240.239.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0EFAE /* 157.240.239.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F020 /* 157.240.240.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F03F /* 157.240.240.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F0AC /* 157.240.240.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F0AE /* 157.240.240.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F120 /* 157.240.241.32/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F13F /* 157.240.241.63/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F1AC /* 157.240.241.172/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F1AE /* 157.240.241.174/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },
  { 0x9DF0F1C4 /* 157.240.241.196/32 */, 32, NDPI_PROTOCOL_INSTAGRAM },

  /*
    OCS GO (Orange Cinéma Séries)
    TODO: are we able to autogenerate this list?
  */

  { 0xB2F8D000 /* 178.248.208.0 */, 21, NDPI_PROTOCOL_OCS },


  /* Teamviewer
   router1.teamviewer.com... router16.teamviewer.com 
   TODO: are we able to autogenerate this list (like the other Teamviewer IPs)?
  */
  { 0x25FCE044 /* 37.252.224.68 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE048 /* 37.252.224.72 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE04C /* 37.252.224.76 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE784 /* 37.252.231.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE788 /* 37.252.231.136 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE864 /* 37.252.232.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE868 /* 37.252.232.104 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE86C /* 37.252.232.108 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF664 /* 37.252.246.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF668 /* 37.252.246.104 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF764 /* 37.252.247.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF768 /* 37.252.247.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF770 /* 37.252.247.112 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF772 /* 37.252.247.114 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFD64 /* 37.252.253.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFD68 /* 37.252.253.104 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEA4 /* 37.252.254.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEA8 /* 37.252.254.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEB0 /* 37.252.254.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEB8 /* 37.252.254.184 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEBC /* 37.252.254.188 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFC4 /* 37.252.255.196 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFC8 /* 37.252.255.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFD0 /* 37.252.255.208 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFD2 /* 37.252.255.210 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x32751BD8 /* 50.117.27.216 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x44446410 /* 68.68.100.16 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x462634C8 /* 70.38.52.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006A4 /* 94.16.6.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006A8 /* 94.16.6.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006B0 /* 94.16.6.176 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006B2 /* 94.16.6.178 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x6CA399D8 /* 108.163.153.216 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05602 /* 158.176.86.2 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05604 /* 158.176.86.4 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05608 /* 158.176.86.8 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB0560A /* 158.176.86.10 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB0560C /* 158.176.86.12 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05610 /* 158.176.86.16 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085884 /* 159.8.88.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085888 /* 159.8.88.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085890 /* 159.8.88.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085892 /* 159.8.88.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E2 /* 159.8.229.226 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E4 /* 159.8.229.228 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E8 /* 159.8.229.232 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5F0 /* 159.8.229.240 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6C4 /* 159.122.182.196 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6C8 /* 159.122.182.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6D0 /* 159.122.182.208 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6D2 /* 159.122.182.210 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7ABD20 /* 159.122.189.32 */, 27, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4362 /* 161.156.67.98 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4364 /* 161.156.67.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4368 /* 161.156.67.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4370 /* 161.156.67.112 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE2 /* 169.51.77.226 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE4 /* 169.51.77.228 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE8 /* 169.51.77.232 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8E0AE0 /* 174.142.10.224 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8EEBE8 /* 174.142.235.232 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8EEC78 /* 174.142.236.120 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A84 /* 178.255.154.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A88 /* 178.255.154.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A90 /* 178.255.154.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A92 /* 178.255.154.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BA4 /* 178.255.155.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BA8 /* 178.255.155.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BB0 /* 178.255.155.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BBC /* 178.255.155.188 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BBE /* 178.255.155.190 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB86B0EA8 /* 184.107.14.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C84 /* 188.65.76.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C88 /* 188.65.76.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C8C /* 188.65.76.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC064 /* 188.172.192.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC068 /* 188.172.192.104 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC06C /* 188.172.192.108 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC684 /* 188.172.198.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC688 /* 188.172.198.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC690 /* 188.172.198.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC698 /* 188.172.198.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC69C /* 188.172.198.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC69E /* 188.172.198.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB84 /* 188.172.219.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB88 /* 188.172.219.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB90 /* 188.172.219.144 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9B /* 188.172.219.155 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9C /* 188.172.219.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9E /* 188.172.219.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF64 /* 188.172.223.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF68 /* 188.172.223.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF70 /* 188.172.223.112 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF72 /* 188.172.223.114 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9A4 /* 188.172.233.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9A8 /* 188.172.233.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B0 /* 188.172.233.176 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B2 /* 188.172.233.178 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B4 /* 188.172.233.180 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B8 /* 188.172.233.184 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB84 /* 188.172.235.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB88 /* 188.172.235.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB90 /* 188.172.235.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB98 /* 188.172.235.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB9C /* 188.172.235.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB9E /* 188.172.235.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF584 /* 188.172.245.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF588 /* 188.172.245.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF590 /* 188.172.245.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF592 /* 188.172.245.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6A4 /* 188.172.246.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6A8 /* 188.172.246.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6B0 /* 188.172.246.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BA /* 188.172.246.186 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BC /* 188.172.246.188 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BE /* 188.172.246.190 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE84 /* 188.172.254.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE88 /* 188.172.254.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE8C /* 188.172.254.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xC0AF7958 /* 192.175.121.88 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A264 /* 213.227.162.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A268 /* 213.227.162.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A270 /* 213.227.162.112 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A27C /* 213.227.162.124 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A27E /* 213.227.162.126 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A384 /* 213.227.163.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A388 /* 213.227.163.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A390 /* 213.227.163.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A884 /* 213.227.168.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A888 /* 213.227.168.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A890 /* 213.227.168.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B984 /* 213.227.185.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B988 /* 213.227.185.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B98C /* 213.227.185.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA84 /* 213.227.186.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA88 /* 213.227.186.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA90 /* 213.227.186.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA98 /* 213.227.186.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA9C /* 213.227.186.156 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920284 /* 217.146.2.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920288 /* 217.146.2.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920484 /* 217.146.4.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920488 /* 217.146.4.136 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920844 /* 217.146.8.68 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920848 /* 217.146.8.72 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD992084C /* 217.146.8.76 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D84 /* 217.146.13.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D88 /* 217.146.13.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D90 /* 217.146.13.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D92 /* 217.146.13.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E84 /* 217.146.14.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E88 /* 217.146.14.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E8C /* 217.146.14.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921584 /* 217.146.21.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921588 /* 217.146.21.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD992158C /* 217.146.21.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921784 /* 217.146.23.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921788 /* 217.146.23.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921790 /* 217.146.23.144 */, 28, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217A0 /* 217.146.23.160 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217A8 /* 217.146.23.168 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217AC /* 217.146.23.172 */, 32, NDPI_PROTOCOL_TEAMVIEWER },

#if 0
  /*
    IFLIX services -by www.vizuamatix.com R&D team
  */
  { 0x344D0000 /* 52.77.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x34DC0000 /* 52.220.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x344A0000 /* 52.74.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x36E69F00 /* 54.230.159.0 */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x36C09C50 /* 54.192.156.80  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36FBB6A8 /* 54.251.182.168*/, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36C09600 /* 54.192.150.0  */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x344AC0F7 /* 52.74.192.247  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x0215E718 /* 2.21.231.24 */, 32, NDPI_PROTOCOL_IFLIX },
#endif

  /*
    Viber Media S.à r.l.
    https://whois.arin.net/rest/nets;q=AWS-VIBER-MEDIA?showDetails=true&showARIN=false&showNonArinTopLevelNet=false&ext=netref2
    TODO: are we able to autogenerate this list?
  */

  { 0x0DE61550 /* 13.230.21.80/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x0D39B480 /* 13.57.180.128/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x012C30400 /* 18.195.4.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x012C45500 /* 18.196.85.0/25 */, 25, NDPI_PROTOCOL_VIBER },
  { 0x022E8A340 /* 34.232.163.64/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x022F67200 /* 34.246.114.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x3400FC00 /* 52.0.252.0/22 */, 22, NDPI_PROTOCOL_VIBER },
  { 0x3403A746 /* 52.3.167.70/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34162CEB /* 52.22.44.235/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34165F0F /* 52.22.95.15/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3640BFF0 /* 54.64.191.240/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x3655545D /* 54.85.84.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3655565D /* 54.85.86.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFD0 /* 54.165.255.208/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFE0 /* 54.165.255.224/27 */, 27, NDPI_PROTOCOL_VIBER },
  { 0x36DBBFA0 /* 54.219.191.160/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36E8FB90 /* 54.232.251.144/28 */, 28, NDPI_PROTOCOL_VIBER },

  /* AnyDesk
    TODO: are we able to autogenerate this list?
  */
  { 0x3353EF8E /* 51.83.239.142/31 */, 31, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EF90 /* 51.83.239.144/31 */, 31, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EEC8 /* 51.83.238.200/29 */, 29, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EED0 /* 51.83.238.208/29 */, 29, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EED8 /* 51.83.238.216/30 */, 30, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EEDC /* 51.83.238.220/31 */, 31, NDPI_PROTOCOL_ANYDESK },

  /*
   * Edgecast CDN
   * Uses captcha to prevent web scraping.
   * https://support.globaldots.com/hc/en-us/articles/115004003849-Edgecast-IP-addresses
   */
  { 0x6CA1F000 /* 108.161.240.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },
  { 0x6EE8B000 /* 110.232.176.0/22 */, 22, NDPI_PROTOCOL_EDGECAST },
  { 0x7567B700 /* 117.103.183.0/24 */, 24, NDPI_PROTOCOL_EDGECAST },
  { 0x7512E800 /* 117.18.232.0/21 */, 21, NDPI_PROTOCOL_EDGECAST },
  { 0x79BD2E00 /* 121.189.46.0/23 */, 23, NDPI_PROTOCOL_EDGECAST },
  { 0xB4F0B800 /* 180.240.184.0/24 */, 24, NDPI_PROTOCOL_EDGECAST },
  { 0xC0100000 /* 192.16.0.0/18 */, 18, NDPI_PROTOCOL_EDGECAST },
  { 0xC0E58000 /* 192.229.128.0/17 */, 17, NDPI_PROTOCOL_EDGECAST },
  { 0xC01E0000 /* 192.30.0.0/19 */, 19, NDPI_PROTOCOL_EDGECAST },
  { 0xC2FFD240 /* 194.255.210.64/26 */, 26, NDPI_PROTOCOL_EDGECAST },
  { 0xC6071000 /* 198.7.16.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },
  { 0xCB4A0440 /* 203.74.4.64/26 */, 26, NDPI_PROTOCOL_EDGECAST },
  { 0xD540EA00 /* 213.64.234.0/26 */, 26, NDPI_PROTOCOL_EDGECAST },
  { 0x2E164000 /* 46.22.64.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },
  { 0x05684000 /* 5.104.64.0/21 */, 21, NDPI_PROTOCOL_EDGECAST },
  { 0x44E82000 /* 68.232.32.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },
  { 0x48155000 /* 72.21.80.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },
  { 0x58C22D80 /* 88.194.45.128/26 */, 26, NDPI_PROTOCOL_EDGECAST },
  { 0x5DB8D000 /* 93.184.208.0/20 */, 20, NDPI_PROTOCOL_EDGECAST },

  /*
    TODO

    Salesforce
    https://help.salesforce.com/s/articleView?id=000321501&type=1
  */

#ifdef CUSTOM_NDPI_PROTOCOLS
#include "../../../nDPI-custom/custom_ndpi_content_match_host_protocol_list.c.inc"
#endif

  /* End */
  { 0x0, 0, 0 }
};


/* ****************************************************** */

/*
  Host-based match

  HTTP:  Server: field
  HTTPS: Server certificate name

  Risk classification criteria
  ----------------------------

  NDPI_PROTOCOL_SAFE
  - Web sites (and CDNs) which are not commonly used to host malicious activities.
  - OS update hosts.
  - App stores.
  - Commonly used services with passwords in encrypted channels (SMTPS, POPS, etc)

  NDPI_PROTOCOL_ACCEPTABLE
  - Cloud services may be used to host malware (e.g., https://www.fireeye.com/blog/threat-research/2015/11/china-based-threat.html),
  but it is mostly used for normal purposes.
  - Webmail sites, which can be used to phising.
  - Encrypted administrative protocols, such as SSH.
  - Text, voice or video communication (e.g., Skype, Slack, Whatsapp).
  - Ads services are commonly used to spread malware
  (https://www.tripwire.com/state-of-security/security-data-protection/crypto-ransomware-spreads-via-poisoned-ads-on-major-websites/)

  NDPI_PROTOCOL_FUN
  - Social media sites and services.
  - Communication used for fun purposes, like Snapchat, Tinder, etc.
  - Audio and videostreamming services (e.g., Netflix).
  - Game services.

  NDPI_PROTOCOL_UNSAFE
  - Unencrypted administrative protocols, such as Telnet.
  - Cloud hosted servers when accessed by default domains, such as *.amazonaws.com.
  - "AWS Supports 41% of Malware Hosting Sites, More than Any Other Web Host or ISP"
  http://www.thewhir.com/web-hosting-news/aws-supports-41-malware-hosting-sites-web-host-isp
  - https://www.scmagazine.com/600-plus-cloud-repositories-spotted-hosting-malware-and-malicious-files/article/572205/
  - https://howtoremove.guide/remove-s3-amazonaws-virus/
  - Torrents.
  - Commonly used services with passwords in unencrypted channels (SMTP, POP, etc)

  NDPI_PROTOCOL_POTENTIALLY_DANGEROUS
  - Tor and other anonymization access.
  - Sites commonly used to host malware and not as commonly used by "normal" users. (e.g., pastebin.com)
  https://isc.sans.edu/forums/diary/Many+Malware+Samples+Found+on+Pastebin/22036/

  NDPI_PROTOCOL_UNRATED
  - Avoid this class.

*/

/* ****************************************************** */

static ndpi_protocol_match host_match[] =
  {
   { "dmqdd6hw24ucf.cloudfront.net",                      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "d25xi40x97liuc.cloudfront.net",                     "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aiv-delivery.net",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aiv-cdn.net",                                      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "1s3.lvlt.dash.us.aiv-cdn.net.c.footprint.net",      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".s.loris.llnwd.net",                                "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "atv-ext.amazon.com",                                "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "atv-ps.amazon.com",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".media-amazon.com",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".amazonvideo.com",                                  "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".primevideo.com",                                   "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "amazon.",                                           "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "amazon.com",                                        "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "images-amazon.com",                                 "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ssl-images-amazon.com",                             "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "amazonaws.com",                                     "AmazonAWS",        NDPI_PROTOCOL_AMAZON_AWS, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "amazon-adsystem.com",                               "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aws.",                                             "AmazonAWS",        NDPI_PROTOCOL_AMAZON_AWS, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".cloudfront.net",                                   "AmazonAWS",        NDPI_PROTOCOL_AMAZON_AWS, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".us-west-2.compute.amazonaws.com",                  "AmazonAWS",        NDPI_PROTOCOL_AMAZON_AWS, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".teamviewer.com",                                   "Teamviewer",       NDPI_PROTOCOL_TEAMVIEWER, NDPI_PROTOCOL_CATEGORY_REMOTE_ACCESS, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".bloombergvault.com",                               "Bloomberg",        NDPI_PROTOCOL_BLOOMBERG, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".bloomberg.com",                                    "Bloomberg",        NDPI_PROTOCOL_BLOOMBERG, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".salesforce.com",                                   "Salesforce",       NDPI_PROTOCOL_SALESFORCE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".apple-dns.net",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "origin-apple.com.akadns.net",               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e6858.dsce9.akamaiedge.net",                "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".mzstatic.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "aaplimg.com",                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".apple.com",                                "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".apple.news",                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".cdn-apple.com",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ls4-apple.com",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gc-apple.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ls-apple.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".apple-cloudkit.com",                       "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".push.apple.com",                           "ApplePush",        NDPI_PROTOCOL_APPLE_PUSH, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "push-apple.com",                            "ApplePush",        NDPI_PROTOCOL_APPLE_PUSH, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".icloud.com",                               "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".icloud.com.",                              "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL }, /* icloud.com.akadns.net */
   { ".me.com",                                   "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".icloud-content.com",                       "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "iosapps.itunes.apple.com",                  "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL }, /* iOS */
   { "osxapps.itunes.apple.com",                  "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL }, /* MacOS */
   { "buy.itunes.apple.com",                      "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "su.itunes.apple.com",                       "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "se.itunes.apple.com",                       "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "myapp.itunes.apple.com",                    "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "swscan.apple.com",                          "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "itunes-apple.com",                          "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "itunes.apple.com",                          "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tlnk.io",         	                      "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "guzzoni.apple.",         	   "AppleSiri",      NDPI_PROTOCOL_APPLE_SIRI, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wbagora.com",                              "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_UNRATED, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wbplay.com",                                "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_UNRATED, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".xbox.com",                                    "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".xboxlive.com",                            "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".xboxlive.com.akadns.net",                 "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".xboxlive.com.c.footprint.net",            "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e13555.b.akamaiedge.net",   "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e1800.d.akamaiedge.net",     "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e1879.e7.akamaiedge.net",   "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".cnn.com",           "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".cnn.net",           "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".dropbox.com",             "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dropboxstatic.com", "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dropbox-dns.com",     "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "log.getdropbox.com", "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".ebay.",                      "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },  /* or FUN */
   { ".ebay.com",                            "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ebaystatic.com",       "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ebaydesc.com",           "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ebayrtm.com",             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ebaystratus.com",     "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ebayimg.com",             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* Detected "instagram.c10r.facebook.com". Omitted "*amazonaws.com" and "*facebook.com" CDNs e.g. "ig-telegraph-shv-04-frc3.facebook.com" */
   { ".instagram.",            "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "instagram.",                "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, 15 },
   { ".cdninstagram.com",   "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "igcdn-photos-",          "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "instagramimages-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "instagramstatic-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "facebook.com",            "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".facebook.net",           "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "fbstatic-a.akamaihd.net", "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fbcdn.net",              "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "fbcdn-",                  "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fbsbx.com",              "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fbwat.ch",               "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fb.com",                 "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fb.gg",                  "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "speedtest.",                       "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ooklaserver.net",         "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "ntop.org",                     "ntop",         NDPI_PROTOCOL_NTOP, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "docs.googleusercontent.com",   "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "docs.google.com",              "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "drive-thirdparty.googleusercontent.com",  "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "drive.google.com",                          "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "android.clients.google.com",   "PlayStore",    NDPI_PROTOCOL_PLAYSTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     https://www.fastvue.co/sophos/blog/google-data-saver-affect-security-confidentiality-reporting/
     Used by Google Chrome Lite Mode for Android

     This traffic will bypass checks and blocks as it will include all the communications from/to
     the browser instead of using the standard communication mechanisms SSL/HTTP(S)/DNS

     https://github.com/curl/curl/wiki/DNS-over-HTTPS
   */
   { ".googlezip.net",                       "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "datasaver.googleapis.com", "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* http://check.googlezip.net/connect [check browser connectivity] */
   // { ".googlezip.net",                   "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
      https://github.com/bambenek/block-doh/blob/master/db.doh-redirect
      https://github.com/curl/curl/wiki/DNS-over-HTTPS
   */
   { "dns.google", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.google.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mozilla.cloudflare-dns.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL }, /* Firefox */
   { "cloudflare-dns.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "commons.host", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.libredns.gr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns9.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.opendns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.dns.sb", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.netweaver.uk", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.dns-over-https.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "jp.tiarap.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.dnsoverhttps.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.powerdns.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "adblock.mydns.network", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "jp.tiar.app", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.crypto.sx", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.containerpi.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ibksturm.synology.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.captnemo.in", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.rubyfish.cn", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.42l.fr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns-family.adguard.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "appliedprivacy.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.cleanbrowsing.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns10.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh-ch.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.seby.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.adguard.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ibuki.cgnat.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "jcdns.fun", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh-2.seby.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.tiar.app", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.dnswarden.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh-de.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh-jp.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.appliedprivacy.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.tiarap.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.armadillodns.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns-nyc.aaflalo.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.aa.net.uk", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.aaflalo.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns11.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.nextdns.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.securedns.eu", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "rdns.faelix.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "captnemo.in", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.dnshome.de", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.dnslify.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "resolver-eu.lelux.fi", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.bortzmeyer.fr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".doh.dns.snopyta.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "jarjar.meganerd.nl", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "rumpelsepp.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dnsnl.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dnses.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dnsse.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "odvr.nic.cz", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns1.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns2.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.digitale-gesellschaft.ch", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns1.digitale-gesellschaft.ch", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dns.cloudflare.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "doh.ffmuc.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },


   /*
     See https://better.fyi/trackers/

     DoubleClick by Google (2mdn.net)
     DoubleClick by Google (doubleclick.net)
     DoubleClick by Google
     Google AdSense by Google (google.com)
     Google AdSense by Google (google.se)
     Google AdSense by Google (googleadservices.com)
     Google Analytics by Google (google-analytics.com)
     Google APIs by Google (ajax.googleapis.com)
     Google Fonts by Google (fonts.googleapis.com)
     Google Interactive Media Ads (imasdk.googleapis.com)
     Google Syndication (googlesyndication.com)
     Google Tag Manager by Google (googletagmanager.com)
     Google Tag Manager by Google (googletagservices.com)
     Gstatic by Google (gstatic.com)
   */

   /* Google Advertisements */
   { ".googlesyndication.com",   "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "googleads.",                           "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".doubleclick.net",               "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "googleadservices.",             "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".2mdn.net",                             "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dmtry.com",                           "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "google-analytics.",             "Google",           NDPI_PROTOCOL_GOOGLE, CUSTOM_CATEGORY_ADVERTISEMENT, NDPI_PROTOCOL_TRACKER_ADS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gvt1.com",                                 "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gvt2.com",                                 "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "telephony.goog",                            "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* Google Hangout */
   { "images2-hangout-opensocial.googleusercontent.com", "GoogleHangout", NDPI_PROTOCOL_HANGOUT_DUO, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* Google Services */
   { "googleapis.com",                     "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".googletagmanager.com",   "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".googletagservices.com",   "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mtalk.google.com",               "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "plus.google.com",                 "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "plus.url.google.com",       "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "googleusercontent.com",       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "1e100.net",                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "maps.google.",                    "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "maps.gstatic.com",               "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".gmail.",                              "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "inbox.google.com",                     "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mail.google.",                    "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "google.com",                             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "google.",                                "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".google.",                                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gstatic.com",                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ggpht.com",                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".goog",                               "Google",        NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "mail.outlook.com",                   "Outlook",          NDPI_PROTOCOL_MS_OUTLOOK, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".last.fm",                            "LastFM",           NDPI_PROTOCOL_LASTFM, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "netflix.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "nflxext.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "nflximg.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "nflximg.net",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "nflxvideo.net",                         "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "nflxso.net",                            "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "fast.com",                              "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".skype.",                                    "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".skypeassets.",                              "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".skypedata.",                                "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".skypeecs-",                                 "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".skypeforbusiness.",                         "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".lync.com",                                  "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e7768.b.akamaiedge.net",                     "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e4593.dspg.akamaiedge.net",                  "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e4593.g.akamaiedge.net",                     "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "*.gateway.messenger.live.com",               "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "skype-calling-missedcallsregistrar-",        "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.cloudapp.net",                         "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".tuenti.com",                              "Tuenti",           NDPI_PROTOCOL_TUENTI, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".twttr.com",                                "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "twitter.",                                  "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "twimg.com",                                 "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN , NDPI_PROTOCOL_DEFAULT_LEVEL},
   { "t.co",                                      "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN , NDPI_PROTOCOL_DEFAULT_LEVEL},

   { ".viber.com",                                "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".cdn.viber.com",                            "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".viber.it",                                 "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "wikipedia.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "wikimedia.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mediawiki.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "wikimediafoundation.",                     "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "mmg-fna.whatsapp.net",            "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fna.whatsapp.net",               "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".cdn.whatsapp.net",               "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mms.whatsapp.net",                "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".whatsapp.",                      "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "g.whatsapp.net",                  "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "v.whatsapp.net",                  "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mmg.whatsapp.net",                "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".yahoo.",                                  "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".yimg.com",                                "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "yahooapis.",                               "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "upload.youtube.com",                "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "upload.video.google.com",           "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "youtubei.googleapis.com",           "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "youtube.",                          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "youtu.be",                          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "yt3.ggpht.com",                     "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".googlevideo.com",                  "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ytimg.com",                        "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "youtube-nocookie.",                 "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".youtube-ui.l.google.com",          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".youtubeeducation.com",             "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".vevo.com",                               "Vevo",             NDPI_PROTOCOL_VEVO,    NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".spotify.com",                            "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".scdn.co",                                "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".pscdn.co",                               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotifycdn.net",                          "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotifycdn.com",                          "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "audio4-ak-spotify-com.akamaized.net",     "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "audio-ak-spotify-com.akamaized.net",      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "heads-ak-spotify-com.akamaized.net",      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotify-com.akamaized.net",               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotify.com.edgesuite.net",               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotify.map.fastly.net",                  "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotify.edgekey.net",                     "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spotify.demdex.net",                      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".spotilocal.com",                         "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },


   { "edge-mqtt.facebook.com",        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mqtt-mini.facebook.com",        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL }, /* Messenger Lite */
   { "messenger.com",                 "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".m.me",                         "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

    /* Pandora */
   { "pandora.com",                  "Pandora",           NDPI_PROTOCOL_PANDORA,  NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".torproject.org",               "Tor",               NDPI_PROTOCOL_TOR, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".kakao.com",                    "KakaoTalk",          NDPI_PROTOCOL_KAKAOTALK, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "ttvnw.net",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "jtvnw.net",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "twitch.tv",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "twitchcdn.net",                   "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN , NDPI_PROTOCOL_DEFAULT_LEVEL},
   { "twitchsvc.net",                   "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".qq.com",                                      "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gtimg.com",                                "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".weibo.com",                                "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".weibo.cn",                                           "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sinaimg.cn",                             "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sinajs.cn",                               "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sina.cn",                                   "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sina.com.cn",                       "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* https://support.cipafilter.com/index.php?/Knowledgebase/Article/View/117/0/snapchat---how-to-block */
   { "feelinsonice.appspot.com",                     "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "feelinsonice-hrd.appspot.com", "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "feelinsonice.com",                          "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".snapchat.",                                  "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".snapads.",                                    "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sc-cdn.net",                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sc-prod.net",                           "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sc-jpl.com",                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sc-analytics.appspot.com",       "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "snap.api.mapbox.com",            "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".waze.com",                                  "Waze",             NDPI_PROTOCOL_WAZE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "wazespeechactiviation-pa.googleapis.com",    "Waze",             NDPI_PROTOCOL_WAZE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "deezer.com",                              "Deezer",           NDPI_PROTOCOL_DEEZER, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* Microsoft + Azure */
   { ".wpc.v0cdn.net",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gfx.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aka.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sfx.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".appcenter.ms",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "-msedge.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".microsoft.us",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dynamics.com",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "msftncsi.com",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".windows.net",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".windows.com",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".microsoft.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "msn.com",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".s-msft.com",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".webtrends.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msecnd.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bing.com",                                              "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".visualstudio.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "login.live.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "statics-marketingsites-wcus-ms-com.akamaized.net",      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "statics-marketingsites-eus-ms-com.akamaized.net",       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "img-prod-cms-rt-microsoft-com.akamaized.net",           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "onecollector.cloudapp.aria.akadns.net",                 "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "onecollector.akadns.net",                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "microsoft.akadns.net",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "e1723.dscd.akamaiedge.net",                             "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".microsofttranslator.com",                              "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sharepointonline.com",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msftconnecttest.com",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".windowsmedia.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".windowsphone.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msa.akadns6.net",                                      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".s-microsoft.com",                                      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msidentity.com",                                       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wac.phicdn.net",                                       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".onestore.ms",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msedge.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".mshome.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "..msn-com.",                                            "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".-s-msn-com.",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".s-msn.com",                                            "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".img-s-msn-com.",                                       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "img-s-msn-com.",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".location.live.net",                                    "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".virtualearth.net",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "trafficmanager.net",                                    "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".azure.com",                                            "Azure",        NDPI_PROTOCOL_MICROSOFT_AZURE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".azureedge.us",                                         "Azure",        NDPI_PROTOCOL_MICROSOFT_AZURE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".azurefd.us",                                           "Azure",        NDPI_PROTOCOL_MICROSOFT_AZURE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".azure-automation.net",                                 "Azure",        NDPI_PROTOCOL_MICROSOFT_AZURE, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".azureedge.net",                                        "Azure",        NDPI_PROTOCOL_MICROSOFT_AZURE, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "teams.microsoft.com",              "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.microsoft.us",               "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.skype.com",                  "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "-teams.cloudapp.net",              "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.trafficmanager.net",         "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams-msgapi.trafficmanager.net",  "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.office.net",                 "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "teams.office.com",                 "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".storage.live.com",               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE,NDPI_PROTOCOL_CATEGORY_CLOUD,  NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "skyapi.live.net",                 "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "d.docs.live.net",                 "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "onedrive.live.com",               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "cs9.wac.phicdn.net",              "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dl.delivery.mp.microsoft.com.",  "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".delivery.dsp.mp.microsoft.com.nsatc.net", "WindowsUpdate", NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sls.update.microsoft.com",        "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "slscr.update.microsoft.com",      "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "fe3.update.microsoft.com",        "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".mp.microsoft.com.",              "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "fe2.update.microsoft.com.",       "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wac.phicdn.net.",                "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".geo-prod.do.dsp.mp.microsoft.com.", "WindowsUpdate", NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "geo-prod.do.dsp.mp.microsoft.com.",  "WindowsUpdate", NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".delivery.mp.microsoft.com",      "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".emdl.ws.microsoft.com",          "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".prod.do.dsp.mp.microsoft.com",   "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "update.microsoft.com",            "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "update.microsoft.com.akadns.net", "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".windowsupdate.com",              "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ntservicepack.microsoft.com",    "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wustat.windows.com",             "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "worldofwarcraft.com",                "WorldOfWarcraft",  NDPI_PROTOCOL_WORLDOFWARCRAFT, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".anchorfree.",                         "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "hotspotshield.com",                    "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".northghost.com",                      "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".webex.com",                              "Webex",           NDPI_PROTOCOL_WEBEX, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".zoom.us",                                "Zoom",            NDPI_PROTOCOL_ZOOM,  NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".ocsdomain.com",                          "OCS",             NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ocs.fr",                                  "OCS",             NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".ocs.fr",                                 "OCS",             NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".labgency.ws",                            "OCS",             NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".iflix.com",                              "IFLIX",           NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".app.iflixcorp.com",                      "IFLIX",           NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".images.iflixassets.com",                 "IFLIX",           NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "crl.microsoft.com",                       "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "evsecure-ocsp.verisign.com",              "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "evsecure-aia.verisign.com",               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "evsecure-crl.verisign.com",               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".omniroot.com",                           "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".microsoftonline.com",                    "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".microsoftonline.us",                     "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".office365.com",                          "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".office.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "office.net",                              "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msocsp.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".msocdn.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "officeapps.live.com",                     "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "outlook.live.com",                        "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mail.live.com",                           "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "office.live.com",                         "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".onenote.",                               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* http://www.urlquery.net/report.php?id=1453233646161 */
   { "lifedom.top",                                "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "coby.ns.cloudflare.com",      "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "amanda.ns.cloudflare.com",  "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "d295hzzivaok4k.cloudfront.net","OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".opendns.com",                                  "OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* https://get.slack.help/hc/en-us/articles/205138367-Troubleshooting-Slack-connection-issues */
   { "slack.com",                                    "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".slack-msgs.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "slack-files.com",                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "slack-imgs.com",                          "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".slack-edge.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".slack-core.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "slack-redir.net",                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   /* Detected "slack-assets2.s3-us-west-2.amazonaws.com.". Omitted "*amazonaws.com" CDN */
   { "slack-assets2.s3-",                  "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "github.com",                                  "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".github.com",                              "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "github.io",                                           "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".github.io",                                          "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "githubusercontent.com",            "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".githubusercontent.com",        "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "gitlab.com",                                  "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gitlab.com",                                 "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gitlab-static.net",                          "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gitlab.io",                                  "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".gitlab.net",                                 "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".steampowered.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "steamcommunity.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".steamcontent.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".steamstatic.com",                          "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "steamcommunity-a.akamaihd.net",             "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".wechat.com",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wechat.org",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wechatapp.com",                        "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".we.chat",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".wx.",                                          "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".weixin.",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".mmsns.qpic.cn",                     "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "dnscrypt.org",                           "DNScrypt",         NDPI_PROTOCOL_DNSCRYPT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "torrent.",                                   "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "torrents.",                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "torrentz.",                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".nintendo.net",                          "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".nintendo.com",                                       "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".playstation.net",                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".playstation.com",                                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".sonyentertainmentnetwork.com",            "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".linkedin.com",                          "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".licdn.com",                                "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".sndcdn.com",                              "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "soundcloud.com",                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "getrockerbox.com",                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "web.telegram.org",                    "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tdesktop.com",                              "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tupdate.com",                                "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".pastebin.com",                          "Pastebin",         NDPI_PROTOCOL_PASTEBIN, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pastebin.com",                             "Pastebin",         NDPI_PROTOCOL_PASTEBIN, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".ppstream.com",                          "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".pps.tv",                                   "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".hulustream.com",                                 "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "hulu.com",                                        "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "assetshuluimcom-a.akamaihd.net",                  "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ibhuluimcom-a.akamaihd.net",                      "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".huluad.com",                                     "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".huluim.com",                                     "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     VidTO streaming service
   */
   { ".vidto.me",                                 "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".vidto.se",                                           "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "snapcraft.io",                        "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ubuntu.com",                            "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "signal.org",                            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "whispersystems.org",            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "musical.ly",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "byteoversea.com",                       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-tiktok-sign-va-h2.ibyteimg.com",    "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-tiktok-sg.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-tiktok-va.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-musical-va.ibyteimg.com",           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-musical-sg.ibyteimg.com",           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-va-tiktok.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-ad-sg.ibyteimg.com",                "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p21-ad-sg.ibyteimg.com",                "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tiktokcdn.com",                         "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-tiktok-va-h2.ibyteimg.com",         "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-tiktokcdn-com.akamaized.net",       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "p16-va-default.akamaized.net",          "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tiktokcdn.liveplay.myqcloud.com",       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "musemuse.cn",                           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tiktokv.com",                           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bytecdn.cn",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "muscdn.com",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "tiktok.com",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "byted.org",                             "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".tik-tokcdn.com",                       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "v19.byteicdn.com",                      "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "v16m.byteicdn.com",                     "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "brasilbandalarga.com.br",     "EAQ",              NDPI_PROTOCOL_EAQ, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".eaqbr.com.br",                       "EAQ",              NDPI_PROTOCOL_EAQ, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".net.anydesk.com",              "AnyDesk",        NDPI_PROTOCOL_ANYDESK, NDPI_PROTOCOL_CATEGORY_REMOTE_ACCESS, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "discordapp.com",               "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "discordapp.net",               "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "discord.com",                  "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "discord.gg",                   "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "discord.media",                "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Amazon Alexa services
   */
   { "alexa.amazon.com",             "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "amazonalexa.com",              "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-1-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-2-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-3-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-4-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-5-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-6-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-7-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-8-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-9-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-10-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-11-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-12-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-13-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-14-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-15-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-16-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-17-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-18-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avs-alexa-19-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Tumblr social network service
   */
   { "tumblr.com",                   "Tumblr",        NDPI_PROTOCOL_TUMBLR, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Reddit social network service
   */
   { ".redd.it",                   "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".reddit.com",                "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".redditmedia.com",           "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".redditstatic.com",          "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".reddit.map.fastly.net",          "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Pinterest social network service
   */
   { ".pinimg.com",                      "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pinterest.global.map.fastly.net",  "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pinterest.map.fastly.net",         "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pinterest.",                     "Pinterest",        NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pinterest.co.",                  "Pinterest",        NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Disney's DisneyPlus streaming service
   */
   { "dssott.com.akamaized.net",               "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "disney-plus.com",                        "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "disney-plus.net",                        "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "disneyplus.com",                         "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "disneyplus.net",                         "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "dssott.com",                             "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "disneyplus.com.ssl.sc.omtrdc.net",       "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".bamgrid.com",                           "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".registerdisney.go.com",                 "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Likee app
   */
   { ".like.video",               "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".likee.video",              "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".likee.com",                "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".likeevideo.com",           "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".like-video.com",           "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".likeimo.tech",             "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".liketech.tech",            "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bstream.hzmklvdieo.com",    "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bstream.kzhi.tech",         "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /*
     Activision
    */
   { "activision.",           "Activision",        NDPI_PROTOCOL_ACTIVISION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".activision.com",       "Activision",        NDPI_PROTOCOL_ACTIVISION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   /* Vimeo */
   { "vimeo.com",             "Vimeo",        NDPI_PROTOCOL_VIMEO, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".vimeo.com",            "Vimeo",        NDPI_PROTOCOL_VIMEO, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".vimeocdn.com",         "Vimeo",        NDPI_PROTOCOL_VIMEO, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".crashlytics.com",                 "Crashlytics",       NDPI_PROTOCOL_CRASHLYSTICS, NDPI_PROTOCOL_CATEGORY_DATA_TRANSFER, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { ".fuze.com",                        "Fuze",       NDPI_PROTOCOL_FUZE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".fuzemeeting.com",                 "Fuze",       NDPI_PROTOCOL_FUZE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".thinkingphones.com",              "Fuze",       NDPI_PROTOCOL_FUZE, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "alibaba.com",                   "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".alibaba.com",                  "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aliapp.org",                   "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".alicdn.com",                   "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".aliyuncs.com",                 "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".mmstat.com",                   "Alibaba", NDPI_PROTOCOL_ALIBABA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "mask.icloud.com",               "iCloudPrivateRelay", NDPI_PROTOCOL_ICLOUD_PRIVATE_RELAY, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mask-h2.icloud.com",            "iCloudPrivateRelay", NDPI_PROTOCOL_ICLOUD_PRIVATE_RELAY, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mask-api.icloud.com",           "iCloudPrivateRelay", NDPI_PROTOCOL_ICLOUD_PRIVATE_RELAY, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "badoo.com",                     "Badoo", NDPI_PROTOCOL_BADOO, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "badoocdn.com",                  "Badoo", NDPI_PROTOCOL_BADOO, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".badoo.app",                    "Badoo", NDPI_PROTOCOL_BADOO, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "accuweather.com",               "AccuWeather", NDPI_PROTOCOL_ACCUWEATHER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".accuweather.com",              "AccuWeather", NDPI_PROTOCOL_ACCUWEATHER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "zattoo.com",                       "Zattoo", NDPI_PROTOCOL_ZATTOO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".zattoo.com",                      "Zattoo", NDPI_PROTOCOL_ZATTOO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "zattosecurehd2-f.akamaihd.net",    "Zattoo", NDPI_PROTOCOL_ZATTOO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "classroom.google.com",             "GoogleClassroom", NDPI_PROTOCOL_GOOGLE_CLASSROOM, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "fortinet.com",                     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sophos.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sophosxl.net",                     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bitdefender.net",                  "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "kaspersky.com",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "kaspersky-labs.com",               "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mcafee.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "symantec.com",                     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "norton.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "f-secure.com",                     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avira.com",                        "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pandasecurity.com",                "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "avast.com",                        "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "malwarebytes.com",                 "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "trendmicro.com",                   "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".eset.com",                        "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".e5.sk",                           "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bullguard.com",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "paloaltonetworks.com",             "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "crowdstrike.com",                  "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "checkpoint.com",                   "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "darktrace.com",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "rapid7.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "barracuda.com",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sonicwall.com",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".rsa.com",                         "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   /* Popular antispam/reputation web sites */
   { "spamhaus.org",                     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "surbl.org",                        "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "support-intelligence.net",         "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mailspike.net",                    "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spamcop.net",                      "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "rspamd.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "habeas.com",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "bondedsender.org",                 "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "sorbs.net",                        "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "surriel.com",                      "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "spameatingmonkey.net",             "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "senderscore.com",                  "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ixhash.net",                       "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "esvarbl.com",                      "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { ".dnsbl.", /* www.dnsbl.info */     "Cybersec", NDPI_PROTOCOL_CYBERSECURITY, NDPI_PROTOCOL_CATEGORY_CYBERSECURITY, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "iqiyi.com",                        "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "iqiyipic.com",                     "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "iq.com",                           "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "qy.net",                           "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "qiyipic.com",                      "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ppstream.com",                     "PPStream", NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "pluralsight.com",                                                     "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight2.imgix.net",                                              "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight.imgix.net",                                               "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "zn6qzq6caaucudesr-pluralsight.siteintercept.qualtrics.com",           "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "znejw6fzxpoc4z2sj-pluralsight.siteintercept.qualtrics.com",           "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "ip-video-course-exercise-files-us-west-2.s3.us-west-2.amazonaws.com", "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight.demdex.net",                                              "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight.sc.omtrdc.net",                                           "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight.hb.omtrdc.net",                                           "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "pluralsight.tt.omtrdc.net",                                           "Pluralsight", NDPI_PROTOCOL_PLURALSIGHT, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "xiaomi.com",                       "Xiaomi", NDPI_PROTOCOL_XIAOMI, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "xiaomi.net",                       "Xiaomi", NDPI_PROTOCOL_XIAOMI, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "mi.com",                           "Xiaomi", NDPI_PROTOCOL_XIAOMI, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "miui.com",                         "Xiaomi", NDPI_PROTOCOL_XIAOMI, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL },

   { "softether.org",         "Softether", NDPI_PROTOCOL_SOFTETHER, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },
   { "softether-network.net", "Softether", NDPI_PROTOCOL_SOFTETHER, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_ACCEPTABLE, NDPI_PROTOCOL_DEFAULT_LEVEL },

#ifdef CUSTOM_NDPI_PROTOCOLS
#include "../../../nDPI-custom/custom_ndpi_content_match_host_match.c.inc"
#endif

   { NULL, NULL, NDPI_PROTOCOL_UNKNOWN, NDPI_PROTOCOL_CATEGORY_UNSPECIFIED, NDPI_PROTOCOL_SAFE, NDPI_PROTOCOL_DEFAULT_LEVEL }
  };

/* ******************************************************************** */

static ndpi_tls_cert_name_match tls_certificate_match [] = {
  { "CN=AnyDesk Client",               NDPI_PROTOCOL_ANYDESK     },
  { "O=Kakao",                         NDPI_PROTOCOL_KAKAOTALK   },
  { "O=ntop.org",                      NDPI_PROTOCOL_NTOP        },
  { "O=Netflix",                       NDPI_PROTOCOL_NETFLIX     },
  { "O=Cloudflare",                    NDPI_PROTOCOL_CLOUDFLARE  },
  { "CN=simplednscrypt.org",           NDPI_PROTOCOL_DNSCRYPT    },
  { "CN=*.gateway.messenger.live.com", NDPI_PROTOCOL_SKYPE_TEAMS },
  { "OU=FortiGate",                    NDPI_PROTOCOL_FORTICLIENT },
  { "CN=www.update.microsoft.com",     NDPI_PROTOCOL_WINDOWS_UPDATE },

  { NULL, 0 }
};

/* ******************************************************************** */

/*
   IMPORTANT

   Do NOT pur here strings that overlap with string in host_match[]
   specified above
*/

static ndpi_category_match category_match[] = {
   { ".edgecastcdn.net",                 NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".hwcdn.net",                       NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".llnwd.net",                       NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".llns.net",                        NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".fastly.net",                      NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".vultr.com",                       NDPI_PROTOCOL_CATEGORY_CLOUD },
   { "baidu.com",                        NDPI_PROTOCOL_CATEGORY_WEB },
   { "icq.com",                          NDPI_PROTOCOL_CATEGORY_CHAT },
   { "quickplay.com",                    NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".71.am",                           NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".1kxun.",                          NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "tcad.wedolook.com",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".rapidvideo.com",                  NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".playercdn.net",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "showmax.com",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "showmax.akamaized.net",            NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "skyq.sky.com",                     NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "iptv.sky.",                        NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "pcdn.skycdn.",                     NDPI_PROTOCOL_CATEGORY_STREAMING },

   /* https://success.tanaza.com/s/article/How-Automatic-Detection-of-Captive-Portal-works */
   { "captive.apple.com",                NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "captive.apple.com.",               NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK }, /* apple.com.edgekey.net */
   { "thinkdifferent.us",                NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "airport.us",                       NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "gsp1.apple.com",                   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "testconnectivity.microsoft.com",   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "teredo.ipv6.microsoft.com",        NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "teredo.ipv6.microsoft.com.nsatc.net",   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "detectportal.firefox.com",         NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "connectivitycheck.android.com",    NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "connectivitycheck.gstatic.com",    NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "connectivitycheck.platform.hicloud.com",    NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },

   /* Hulu Streaming services AS23286 */
   { "8.28.124.0/24",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.28.125.0/24",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.200.50.0/23",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.200.51.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.60.116.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "208.91.158.0/23",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "209.249.186.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },

   /* Disney Streaming services AS11251 */
   { "8.4.4.0/24",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.5.5.0/24",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.33.30.0/24",                    NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "63.116.222.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "63.116.223.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.192.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.193.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.200.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.201.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.202.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.203.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.204.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.205.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.206.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.207.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.208.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.209.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.212.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.216.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.217.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },

   /*
      ADS and tracking
    */
   /* Smaato is a digital ad tech platform and ad server */
   { ".smaato.net",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   { ".smaato.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* MoPub, a Twitter company, provides monetization solutions */
   { ".mopub.com",                    CUSTOM_CATEGORY_ADVERTISEMENT },
   /* AppsFlyer is a SaaS mobile marketing analytics and attribution platform */
   { ".appsflyer.com",                CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Adjust is the mobile marketing platform for marketers around the world */
   { ".adjust.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Helpshift enables brands to deliver superior digital customer service digital channels*/
   { ".helpshift.com",                CUSTOM_CATEGORY_ADVERTISEMENT },
   /* AppLovin is a mobile marketing platform */
   { ".applovin.com",                 CUSTOM_CATEGORY_ADVERTISEMENT },
   /* AdRight is an innovative online advertising network */
   { ".adright.com",                  CUSTOM_CATEGORY_ADVERTISEMENT },
   /* MGID: Native Visitors Acquisition for Advertisers */
   { ".mgid.com",                     CUSTOM_CATEGORY_ADVERTISEMENT },
   /* InMobi is the world's leading mobile marketing and advertising platform provider */
   { ".inmobi.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* AdColony - Elevating mobile advertising */
   { ".adcolony.com",                 CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Supersonicads: App monetization done right */
   { ".supersonicads.com",            CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Criteo is an advertising company that provides online display advertisements */
   { ".criteo.net",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   { ".criteo.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Flurry is an American mobile analytics, monetization, and advertising company */
   { ".flurry.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Taboola is the world's leading discovery & native advertising platform */
   { ".taboola.com",                  CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Market research community, a leading global market research effort that studies and reports on Internet trends and behavior. */
   { ".scorecardresearch.com",        CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Magnite Inc. (formerly Rubicon Project) is an American online advertising technology firm */
   { ".rubiconproject.com",           CUSTOM_CATEGORY_ADVERTISEMENT },
   /* Adnxs.com is run by AppNexus, a company that provides technology, data and analytics to help companies buy and sell online display advertising  */
   { ".adnxs.com",                    CUSTOM_CATEGORY_ADVERTISEMENT },
   /* PubMatic, Inc. is a company that develops and implements online advertising software */
   { ".pubmatic.com",                 CUSTOM_CATEGORY_ADVERTISEMENT },
   /* “OpenX’s unified monetization platform */
   { ".openx.net",                    CUSTOM_CATEGORY_ADVERTISEMENT },
   /* AddThis share buttons, targeting tools and content recommendations help you get more likes, shares and followers */
   { ".addthis.com",                  CUSTOM_CATEGORY_ADVERTISEMENT },
   { ".addthisedge.com",              CUSTOM_CATEGORY_ADVERTISEMENT },
   /* NEXAGE offers a mobile advertising platform that provides private and public exchanges */
   { ".nexage.com",                   CUSTOM_CATEGORY_ADVERTISEMENT },
   /* RadiumOne (formerly GWallet) is a digital advertising company */
   { ".gwallet.com",                  CUSTOM_CATEGORY_ADVERTISEMENT },

   { NULL, 0 }
};

