// Netify Agent
// Copyright (C) 2024 eGloo Incorporated
// <http://www.egloo.ca>
//
// This program is free software: you can redistribute it
// and/or modify it under the terms of the GNU General
// Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your
// option) any later version.
//
// This program is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program.  If not, see
// <http://www.gnu.org/licenses/>.

#pragma once

#include <atomic>
#include <cstddef>
#include <cstdint>
#include <ctime>
#include <string>
#include <thread>

constexpr unsigned char nd_progress_chars[][4] = {
    { 0xe2, 0xa1, 0x80, 0x00 }, { 0xe2, 0xa1, 0x81, 0x00 },
    { 0xe2, 0xa1, 0x82, 0x00 }, { 0xe2, 0xa1, 0x83, 0x00 },
    { 0xe2, 0xa1, 0x84, 0x00 }, { 0xe2, 0xa1, 0x85, 0x00 },
    { 0xe2, 0xa1, 0x86, 0x00 }, { 0xe2, 0xa1, 0x87, 0x00 },
    { 0xe2, 0xa1, 0x88, 0x00 }, { 0xe2, 0xa1, 0x89, 0x00 },
    { 0xe2, 0xa1, 0x8a, 0x00 }, { 0xe2, 0xa1, 0x8b, 0x00 },
    { 0xe2, 0xa1, 0x8c, 0x00 }, { 0xe2, 0xa1, 0x8d, 0x00 },
    { 0xe2, 0xa1, 0x8e, 0x00 }, { 0xe2, 0xa1, 0x8f, 0x00 },
    { 0xe2, 0xa1, 0x90, 0x00 }, { 0xe2, 0xa1, 0x91, 0x00 },
    { 0xe2, 0xa1, 0x92, 0x00 }, { 0xe2, 0xa1, 0x93, 0x00 },
    { 0xe2, 0xa1, 0x94, 0x00 }, { 0xe2, 0xa1, 0x95, 0x00 },
    { 0xe2, 0xa1, 0x96, 0x00 }, { 0xe2, 0xa1, 0x97, 0x00 },
    { 0xe2, 0xa1, 0x98, 0x00 }, { 0xe2, 0xa1, 0x99, 0x00 },
    { 0xe2, 0xa1, 0x9a, 0x00 }, { 0xe2, 0xa1, 0x9b, 0x00 },
    { 0xe2, 0xa1, 0x9c, 0x00 }, { 0xe2, 0xa1, 0x9d, 0x00 },
    { 0xe2, 0xa1, 0x9e, 0x00 }, { 0xe2, 0xa1, 0x9f, 0x00 },
    { 0xe2, 0xa1, 0xa0, 0x00 }, { 0xe2, 0xa1, 0xa1, 0x00 },
    { 0xe2, 0xa1, 0xa2, 0x00 }, { 0xe2, 0xa1, 0xa3, 0x00 },
    { 0xe2, 0xa1, 0xa4, 0x00 }, { 0xe2, 0xa1, 0xa5, 0x00 },
    { 0xe2, 0xa1, 0xa6, 0x00 }, { 0xe2, 0xa1, 0xa7, 0x00 },
    { 0xe2, 0xa1, 0xa8, 0x00 }, { 0xe2, 0xa1, 0xa9, 0x00 },
    { 0xe2, 0xa1, 0xaa, 0x00 }, { 0xe2, 0xa1, 0xab, 0x00 },
    { 0xe2, 0xa1, 0xac, 0x00 }, { 0xe2, 0xa1, 0xad, 0x00 },
    { 0xe2, 0xa1, 0xae, 0x00 }, { 0xe2, 0xa1, 0xaf, 0x00 },
    { 0xe2, 0xa1, 0xb0, 0x00 }, { 0xe2, 0xa1, 0xb1, 0x00 },
    { 0xe2, 0xa1, 0xb2, 0x00 }, { 0xe2, 0xa1, 0xb3, 0x00 },
    { 0xe2, 0xa1, 0xb4, 0x00 }, { 0xe2, 0xa1, 0xb5, 0x00 },
    { 0xe2, 0xa1, 0xb6, 0x00 }, { 0xe2, 0xa1, 0xb7, 0x00 },
    { 0xe2, 0xa1, 0xb8, 0x00 }, { 0xe2, 0xa1, 0xb9, 0x00 },
    { 0xe2, 0xa1, 0xba, 0x00 }, { 0xe2, 0xa1, 0xbb, 0x00 },
    { 0xe2, 0xa1, 0xbc, 0x00 }, { 0xe2, 0xa1, 0xbd, 0x00 },
    { 0xe2, 0xa1, 0xbe, 0x00 }, { 0xe2, 0xa1, 0xbf, 0x00 },
    { 0xe2, 0xa2, 0x80, 0x00 }, { 0xe2, 0xa2, 0x81, 0x00 },
    { 0xe2, 0xa2, 0x82, 0x00 }, { 0xe2, 0xa2, 0x83, 0x00 },
    { 0xe2, 0xa2, 0x84, 0x00 }, { 0xe2, 0xa2, 0x85, 0x00 },
    { 0xe2, 0xa2, 0x86, 0x00 }, { 0xe2, 0xa2, 0x87, 0x00 },
    { 0xe2, 0xa2, 0x88, 0x00 }, { 0xe2, 0xa2, 0x89, 0x00 },
    { 0xe2, 0xa2, 0x8a, 0x00 }, { 0xe2, 0xa2, 0x8b, 0x00 },
    { 0xe2, 0xa2, 0x8c, 0x00 }, { 0xe2, 0xa2, 0x8d, 0x00 },
    { 0xe2, 0xa2, 0x8e, 0x00 }, { 0xe2, 0xa2, 0x8f, 0x00 },
    { 0xe2, 0xa2, 0x90, 0x00 }, { 0xe2, 0xa2, 0x91, 0x00 },
    { 0xe2, 0xa2, 0x92, 0x00 }, { 0xe2, 0xa2, 0x93, 0x00 },
    { 0xe2, 0xa2, 0x94, 0x00 }, { 0xe2, 0xa2, 0x95, 0x00 },
    { 0xe2, 0xa2, 0x96, 0x00 }, { 0xe2, 0xa2, 0x97, 0x00 },
    { 0xe2, 0xa2, 0x98, 0x00 }, { 0xe2, 0xa2, 0x99, 0x00 },
    { 0xe2, 0xa2, 0x9a, 0x00 }, { 0xe2, 0xa2, 0x9b, 0x00 },
    { 0xe2, 0xa2, 0x9c, 0x00 }, { 0xe2, 0xa2, 0x9d, 0x00 },
    { 0xe2, 0xa2, 0x9e, 0x00 }, { 0xe2, 0xa2, 0x9f, 0x00 },
    { 0xe2, 0xa2, 0xa0, 0x00 }, { 0xe2, 0xa2, 0xa1, 0x00 },
    { 0xe2, 0xa2, 0xa2, 0x00 }, { 0xe2, 0xa2, 0xa3, 0x00 },
    { 0xe2, 0xa2, 0xa4, 0x00 }, { 0xe2, 0xa2, 0xa5, 0x00 },
    { 0xe2, 0xa2, 0xa6, 0x00 }, { 0xe2, 0xa2, 0xa7, 0x00 },
    { 0xe2, 0xa2, 0xa8, 0x00 }, { 0xe2, 0xa2, 0xa9, 0x00 },
    { 0xe2, 0xa2, 0xaa, 0x00 }, { 0xe2, 0xa2, 0xab, 0x00 },
    { 0xe2, 0xa2, 0xac, 0x00 }, { 0xe2, 0xa2, 0xad, 0x00 },
    { 0xe2, 0xa2, 0xae, 0x00 }, { 0xe2, 0xa2, 0xaf, 0x00 },
    { 0xe2, 0xa2, 0xb0, 0x00 }, { 0xe2, 0xa2, 0xb1, 0x00 },
    { 0xe2, 0xa2, 0xb2, 0x00 }, { 0xe2, 0xa2, 0xb3, 0x00 },
    { 0xe2, 0xa2, 0xb4, 0x00 }, { 0xe2, 0xa2, 0xb5, 0x00 },
    { 0xe2, 0xa2, 0xb6, 0x00 }, { 0xe2, 0xa2, 0xb7, 0x00 },
    { 0xe2, 0xa2, 0xb8, 0x00 }, { 0xe2, 0xa2, 0xb9, 0x00 },
    { 0xe2, 0xa2, 0xba, 0x00 }, { 0xe2, 0xa2, 0xbb, 0x00 },
    { 0xe2, 0xa2, 0xbc, 0x00 }, { 0xe2, 0xa2, 0xbd, 0x00 },
    { 0xe2, 0xa2, 0xbe, 0x00 }, { 0xe2, 0xa2, 0xbf, 0x00 },
    { 0xe2, 0xa3, 0x80, 0x00 }, { 0xe2, 0xa3, 0x81, 0x00 },
    { 0xe2, 0xa3, 0x82, 0x00 }, { 0xe2, 0xa3, 0x83, 0x00 },
    { 0xe2, 0xa3, 0x84, 0x00 }, { 0xe2, 0xa3, 0x85, 0x00 },
    { 0xe2, 0xa3, 0x86, 0x00 }, { 0xe2, 0xa3, 0x87, 0x00 },
    { 0xe2, 0xa3, 0x88, 0x00 }, { 0xe2, 0xa3, 0x89, 0x00 },
    { 0xe2, 0xa3, 0x8a, 0x00 }, { 0xe2, 0xa3, 0x8b, 0x00 },
    { 0xe2, 0xa3, 0x8c, 0x00 }, { 0xe2, 0xa3, 0x8d, 0x00 },
    { 0xe2, 0xa3, 0x8e, 0x00 }, { 0xe2, 0xa3, 0x8f, 0x00 },
    { 0xe2, 0xa3, 0x90, 0x00 }, { 0xe2, 0xa3, 0x91, 0x00 },
    { 0xe2, 0xa3, 0x92, 0x00 }, { 0xe2, 0xa3, 0x93, 0x00 },
    { 0xe2, 0xa3, 0x94, 0x00 }, { 0xe2, 0xa3, 0x95, 0x00 },
    { 0xe2, 0xa3, 0x96, 0x00 }, { 0xe2, 0xa3, 0x97, 0x00 },
    { 0xe2, 0xa3, 0x98, 0x00 }, { 0xe2, 0xa3, 0x99, 0x00 },
    { 0xe2, 0xa3, 0x9a, 0x00 }, { 0xe2, 0xa3, 0x9b, 0x00 },
    { 0xe2, 0xa3, 0x9c, 0x00 }, { 0xe2, 0xa3, 0x9d, 0x00 },
    { 0xe2, 0xa3, 0x9e, 0x00 }, { 0xe2, 0xa3, 0x9f, 0x00 },
    { 0xe2, 0xa3, 0xa0, 0x00 }, { 0xe2, 0xa3, 0xa1, 0x00 },
    { 0xe2, 0xa3, 0xa2, 0x00 }, { 0xe2, 0xa3, 0xa3, 0x00 },
    { 0xe2, 0xa3, 0xa4, 0x00 }, { 0xe2, 0xa3, 0xa5, 0x00 },
    { 0xe2, 0xa3, 0xa6, 0x00 }, { 0xe2, 0xa3, 0xa7, 0x00 },
    { 0xe2, 0xa3, 0xa8, 0x00 }, { 0xe2, 0xa3, 0xa9, 0x00 },
    { 0xe2, 0xa3, 0xaa, 0x00 }, { 0xe2, 0xa3, 0xab, 0x00 },
    { 0xe2, 0xa3, 0xac, 0x00 }, { 0xe2, 0xa3, 0xad, 0x00 },
    { 0xe2, 0xa3, 0xae, 0x00 }, { 0xe2, 0xa3, 0xaf, 0x00 },
    { 0xe2, 0xa3, 0xb0, 0x00 }, { 0xe2, 0xa3, 0xb1, 0x00 },
    { 0xe2, 0xa3, 0xb2, 0x00 }, { 0xe2, 0xa3, 0xb3, 0x00 },
    { 0xe2, 0xa3, 0xb4, 0x00 }, { 0xe2, 0xa3, 0xb5, 0x00 },
    { 0xe2, 0xa3, 0xb6, 0x00 }, { 0xe2, 0xa3, 0xb7, 0x00 },
    { 0xe2, 0xa3, 0xb8, 0x00 }, { 0xe2, 0xa3, 0xb9, 0x00 },
    { 0xe2, 0xa3, 0xba, 0x00 }, { 0xe2, 0xa3, 0xbb, 0x00 },
    { 0xe2, 0xa3, 0xbc, 0x00 }, { 0xe2, 0xa3, 0xbd, 0x00 },
    { 0xe2, 0xa3, 0xbe, 0x00 }, { 0xe2, 0xa3, 0xbf, 0x00 }
};

constexpr size_t nd_progress_size = (sizeof(nd_progress_chars) / 4);

class ndProgress
{
public:
    enum class Type : uint8_t { SPINNER = 1 };
    enum class State : uint8_t {
        INIT = 0,
        PAUSED = 1,
        RUNNING = 2,
        STOPPED = 3
    };

    ndProgress(const std::string &message,
      const std::string &complete);
    virtual ~ndProgress();

    bool Start(void);
    inline bool Pause(void) {
        if (state.load() == State::RUNNING) {
            state = State::PAUSED;
            return true;
        }
        return false;
    };
    inline bool Resume(void) {
        if (state.load() == State::PAUSED) {
            state = State::RUNNING;
            return true;
        }
        return false;
    };
    void Stop(void);
    inline void Stop(const std::string &complete) {
      this->complete = complete;
      Stop();
    }

protected:
    Type type = { Type::SPINNER };
    std::atomic<State> state = { State::INIT };
    std::thread *worker = { nullptr };
    time_t delay = { 200000 };
    std::string message;
    std::string complete;
};
