// Netify Agent
// Copyright (C) 2015-2024 eGloo Incorporated
// <http://www.egloo.ca>
//
// This program is free software: you can redistribute it
// and/or modify it under the terms of the GNU General
// Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your
// option) any later version.
//
// This program is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program.  If not, see
// <http://www.gnu.org/licenses/>.

#pragma once

#include <cstdint>
#include <memory>
#include <string>
#include <regex>
#include <unordered_map>

#include "nd-flow-parser.h"

#include "nd-flow.hpp"
#include "nd-instance.hpp"

#define _NDFP_flow \
    ((ndFlowParser *)yyget_extra(scanner))->flow
#define _NDFP_local_mac \
    ((ndFlowParser *)yyget_extra(scanner))->local_mac
#define _NDFP_other_mac \
    ((ndFlowParser *)yyget_extra(scanner))->other_mac
#define _NDFP_local_ip \
    ((ndFlowParser *)yyget_extra(scanner))->local_ip
#define _NDFP_other_ip \
    ((ndFlowParser *)yyget_extra(scanner))->other_ip
#define _NDFP_local_port \
    ((ndFlowParser *)yyget_extra(scanner))->local_port
#define _NDFP_other_port \
    ((ndFlowParser *)yyget_extra(scanner))->other_port
#define _NDFP_origin \
    ((ndFlowParser *)yyget_extra(scanner))->origin
#define _NDFP_params_intel \
    ((ndFlowParser *)yyget_extra(scanner))->params_intel
#define _NDFP_result \
    ((ndFlowParser *)yyget_extra(scanner))->expr_result
#define _NDFP_categories \
    ((ndFlowParser *)yyget_extra(scanner))->ndi.categories
#define _NDFP_regex_search(rx, search) \
    ((ndFlowParser *)yyget_extra(scanner))->RegExSearch(rx, search)

class ndFlowParser : public ndInstanceClient
{
public:
    ndFlowParser();
    virtual ~ndFlowParser();

    typedef std::unordered_map<std::string, nlohmann::json> Params;

    bool Parse(
      ndFlow::Ptr const &flow, const Params &params, const std::string &expr);
    inline bool Parse(ndFlow::Ptr const &flow, const std::string &expr) {
        Params params;
        return Parse(flow, params, expr);
    }

    bool RegExSearch(std::string &expr, const std::string &search);

    ndFlow::Ptr flow;
    const char *local_mac;
    const char *other_mac;
    const ndAddr *local_ip;
    const ndAddr *other_ip;
    uint16_t local_port;
    uint16_t other_port;
    uint16_t origin;
    const nlohmann::json *params_intel = { nullptr };

    bool expr_result;

protected:
    void *scanner;

    typedef std::unordered_map<std::string, std::unique_ptr<std::regex>> rx_cache_map;
    rx_cache_map rx_cache;
};
